/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.transport.kex.AbstractDhGroup;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexGroup;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexInit;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexReply;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhGexRequest;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public abstract class AbstractDhGroupExchange
extends AbstractDhGroup {
    private static Logger a = Logger.getLogger("AbstractDhGroupExchange");
    private BigInteger b = null;
    private BigInteger c = null;
    private BigInteger d = null;

    @Override
    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        a.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.messageStore.registerMessage(34, SshMsgKexDhGexRequest.class);
        this.messageStore.registerMessage(31, SshMsgKexDhGexGroup.class);
        this.messageStore.registerMessage(33, SshMsgKexDhGexReply.class);
        this.transport.addMessageStore(this.messageStore);
        SshMsgKexDhGexRequest sshMsgKexDhGexRequest = new SshMsgKexDhGexRequest();
        try {
            this.transport.sendMessage(sshMsgKexDhGexRequest, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexDhGexGroup sshMsgKexDhGexGroup = (SshMsgKexDhGexGroup)this.transport.readMessage(nArray);
        this.b = sshMsgKexDhGexGroup.getP();
        this.c = sshMsgKexDhGexGroup.getG();
        ((ElGamalKeyPairGenerator)((Object)this.dhKeyPairGen)).initialize(this.b, this.c, new SecureRandom());
        KeyPair keyPair = this.dhKeyPairGen.generateKeyPair();
        this.d = ((ElGamalPrivateKey)keyPair.getPrivate()).getX();
        this.e = ((ElGamalPublicKey)keyPair.getPublic()).getY();
        SshMsgKexDhGexInit sshMsgKexDhGexInit = new SshMsgKexDhGexInit(this.e);
        try {
            this.transport.sendMessage(sshMsgKexDhGexInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        nArray[0] = 33;
        SshMsgKexDhGexReply sshMsgKexDhGexReply = (SshMsgKexDhGexReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexDhGexReply.getHostKey();
        this.signature = sshMsgKexDhGexReply.getSignature();
        this.f = sshMsgKexDhGexReply.getF();
        if (a.isEnabledFor(Level.ALL)) {
            a.log(Level.ALL, sshMsgKexDhGexGroup.toString(), null);
        }
        this.secret = this.f.modPow(this.d, this.b);
        this.calculateExchangeHash();
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        try {
            a.debug("calculateExchangeHash()");
            Hash hash = this.getHash();
            hash.putString(this.clientId);
            hash.putString(this.serverId);
            hash.putInt(this.clientKexInit.length);
            hash.putBytes(this.clientKexInit);
            hash.putInt(this.serverKexInit.length);
            hash.putBytes(this.serverKexInit);
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
            hash.putInt(SshMsgKexDhGexRequest.DH_GROUP_EXCHANGE_MIN_SIZE);
            hash.putInt(SshMsgKexDhGexRequest.DH_PREFERRED_GROUP_EXCHANGE_SIZE);
            hash.putInt(SshMsgKexDhGexRequest.DH_GROUP_EXCHANGE_MAX_SIZE);
            hash.putBigInteger(this.b);
            hash.putBigInteger(this.c);
            hash.putBigInteger(this.e);
            hash.putBigInteger(this.f);
            hash.putBigInteger(this.secret);
            this.exchangeHash = hash.doFinal();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
    }
}

