/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.transport.kex.AbstractDhGroup;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhInit;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexDhReply;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import xjava.security.interfaces.ElGamalKeyPairGenerator;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public abstract class DhFixedGroup
extends AbstractDhGroup {
    private static Logger a = Logger.getLogger("DhFixedGroup");
    private static final BigInteger b = new BigInteger("2");
    private BigInteger c = null;

    protected abstract BigInteger getP();

    @Override
    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        a.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.messageStore.registerMessage(30, SshMsgKexDhInit.class);
        this.messageStore.registerMessage(31, SshMsgKexDhReply.class);
        this.transport.addMessageStore(this.messageStore);
        ((ElGamalKeyPairGenerator)((Object)this.dhKeyPairGen)).initialize(this.getP(), b, new SecureRandom());
        KeyPair keyPair = this.dhKeyPairGen.generateKeyPair();
        this.c = ((ElGamalPrivateKey)keyPair.getPrivate()).getX();
        this.e = ((ElGamalPublicKey)keyPair.getPublic()).getY();
        SshMsgKexDhInit sshMsgKexDhInit = new SshMsgKexDhInit(this.e);
        try {
            this.transport.sendMessage(sshMsgKexDhInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexDhReply sshMsgKexDhReply = (SshMsgKexDhReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexDhReply.getHostKey();
        this.signature = sshMsgKexDhReply.getSignature();
        this.f = sshMsgKexDhReply.getF();
        if (a.isEnabledFor(Level.ALL)) {
            a.log(Level.ALL, sshMsgKexDhReply.toString(), null);
        }
        this.secret = this.f.modPow(this.c, this.getP());
        this.calculateExchangeHash();
    }

    protected void calculateExchangeHash() throws KeyExchangeException {
        try {
            a.debug("calculateExchangeHash()");
            Hash hash = this.getHash();
            hash.putString(this.clientId);
            hash.putString(this.serverId);
            hash.putInt(this.clientKexInit.length);
            hash.putBytes(this.clientKexInit);
            hash.putInt(this.serverKexInit.length);
            hash.putBytes(this.serverKexInit);
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
            hash.putBigInteger(this.e);
            hash.putBigInteger(this.f);
            hash.putBigInteger(this.secret);
            this.exchangeHash = hash.doFinal();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
    }
}

