/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.kex;

import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexECDhInit;
import com.enterprisedt.net.j2ssh.transport.kex.SshMsgKexECDhReply;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;

public abstract class ECDHSha2
extends SshKeyExchange {
    private static Logger a = Logger.getLogger("ECDHSha2");
    protected String clientId;
    protected String serverId;
    protected byte[] clientKexInit;
    protected byte[] serverKexInit;
    protected byte[] Q_S;
    protected byte[] Q_C;
    protected AsymmetricKeyParameter D_C;
    protected ECDomainParameters ecDomain;

    @Override
    protected void onInit() throws IOException {
    }

    @Override
    public void performClientExchange(String clientId, String serverId, byte[] clientKexInit, byte[] serverKexInit) throws IOException {
        a.info("Starting client side key exchange.");
        this.clientId = clientId;
        this.serverId = serverId;
        this.clientKexInit = clientKexInit;
        this.serverKexInit = serverKexInit;
        this.messageStore.registerMessage(30, SshMsgKexECDhInit.class);
        this.messageStore.registerMessage(31, SshMsgKexECDhReply.class);
        this.transport.addMessageStore(this.messageStore);
        X9ECParameters x9ECParameters = this.getCurve();
        this.ecDomain = new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
        AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.generateKeyPair(this.ecDomain);
        ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
        this.Q_C = eCPublicKeyParameters.getQ().getEncoded(false);
        this.D_C = asymmetricCipherKeyPair.getPrivate();
        SshMsgKexECDhInit sshMsgKexECDhInit = new SshMsgKexECDhInit(this.Q_C);
        try {
            this.transport.sendMessage(sshMsgKexECDhInit, this);
        }
        catch (SshException sshException) {
            throw new KeyExchangeException("Failed to send key exchange initialization message");
        }
        int[] nArray = new int[]{31};
        SshMsgKexECDhReply sshMsgKexECDhReply = (SshMsgKexECDhReply)this.transport.readMessage(nArray);
        this.hostKey = sshMsgKexECDhReply.getHostKey();
        this.signature = sshMsgKexECDhReply.getSignature();
        this.Q_S = sshMsgKexECDhReply.getQS();
        if (a.isEnabledFor(Level.ALL)) {
            a.log(Level.ALL, sshMsgKexECDhReply.toString(), null);
        }
        ECPoint eCPoint = this.ecDomain.getCurve().decodePoint(this.Q_S);
        ECPublicKeyParameters eCPublicKeyParameters2 = new ECPublicKeyParameters(eCPoint, this.ecDomain);
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init(this.D_C);
        this.secret = eCDHBasicAgreement.calculateAgreement(eCPublicKeyParameters2);
        this.calculateExchangeHash();
    }

    protected AsymmetricCipherKeyPair generateKeyPair(ECDomainParameters ecDomain) {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(ecDomain, new SecureRandom()));
        return eCKeyPairGenerator.generateKeyPair();
    }

    protected abstract X9ECParameters getCurve();

    protected void calculateExchangeHash() throws KeyExchangeException {
        try {
            a.debug("calculateExchangeHash()");
            Hash hash = this.getHash();
            hash.putString(this.clientId);
            hash.putString(this.serverId);
            hash.putInt(this.clientKexInit.length);
            hash.putBytes(this.clientKexInit);
            hash.putInt(this.serverKexInit.length);
            hash.putBytes(this.serverKexInit);
            hash.putInt(this.hostKey.length);
            hash.putBytes(this.hostKey);
            hash.putInt(this.Q_C.length);
            hash.putBytes(this.Q_C);
            hash.putInt(this.Q_S.length);
            hash.putBytes(this.Q_S);
            hash.putBigInteger(this.secret);
            this.exchangeHash = hash.doFinal();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyExchangeException("SHA algorithm not supported");
        }
    }
}

