/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.util.Base64;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class OpenSSHPublicKeyFormat
implements SshPublicKeyFormat {
    String a = null;

    public OpenSSHPublicKeyFormat(String comment) {
        this.setComment(comment);
    }

    public OpenSSHPublicKeyFormat() {
    }

    @Override
    public void setComment(String comment) {
        this.a = comment;
    }

    @Override
    public String getComment() {
        return this.a;
    }

    @Override
    public String getFormatType() {
        return "OpenSSH-PublicKey";
    }

    @Override
    public byte[] getKeyBlob(byte[] formattedKey) throws InvalidSshKeyException {
        StringTokenizer stringTokenizer = new StringTokenizer(new String(formattedKey), " \t");
        try {
            String string = stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            if (stringTokenizer.hasMoreTokens()) {
                this.a = stringTokenizer.nextToken();
            }
            if (this.supportsAlgorithm(string)) {
                return Base64.decode(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        throw new InvalidSshKeyException("Failed to read OpenSSH key format");
    }

    @Override
    public byte[] formatKey(byte[] keyblob) {
        String string = ByteArrayReader.readString(keyblob, 0);
        String string2 = string + " " + Base64.encodeBytes(keyblob, true);
        if (this.a != null) {
            string2 = string2 + " " + this.a;
        }
        return string2.getBytes();
    }

    @Override
    public boolean isFormatted(byte[] formattedKey) {
        String string = new String(formattedKey).trim();
        return string.startsWith("ssh-dss") || string.startsWith("ssh-rsa") || string.startsWith("ssh-ed25519") || string.startsWith("ecdsa-sha2-");
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return algorithm.equals("ssh-dss") || algorithm.equals("ssh-rsa") || algorithm.equals("ssh-ed25519") || algorithm.startsWith("ecdsa-sha2-");
    }
}

