/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class SshPrivateKeyFile {
    private static Logger a = Logger.getLogger("SshPrivateKeyFile");
    private SshPrivateKeyFormat b;
    private byte[] c;

    protected SshPrivateKeyFile(byte[] keyblob, SshPrivateKeyFormat format) {
        this.c = keyblob;
        this.b = format;
    }

    public byte[] getBytes() {
        return this.c;
    }

    public byte[] getKeyBlob(String passphrase) throws InvalidSshKeyException {
        return this.b.decryptKeyblob(this.c, passphrase);
    }

    public void changePassphrase(String oldPassphrase, String newPassphrase) throws InvalidSshKeyException {
        byte[] byArray = this.b.decryptKeyblob(this.c, oldPassphrase);
        this.c = this.b.encryptKeyblob(byArray, newPassphrase);
    }

    public static SshPrivateKeyFile parse(byte[] formattedKey) throws InvalidSshKeyException {
        if (formattedKey == null) {
            throw new InvalidSshKeyException("Key data is null");
        }
        a.debug("Parsing private key file");
        SshPrivateKeyFormat sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(SshPrivateKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPrivateKeyFormat.isFormatted(formattedKey);
        if (!bl) {
            a.debug("Private key is not in the default format, attempting parse with other supported formats");
            Iterator iterator = SshPrivateKeyFormatFactory.getSupportedFormats().iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                a.debug("Attempting " + string);
                sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(string);
                bl = sshPrivateKeyFormat.isFormatted(formattedKey);
            }
        }
        if (bl) {
            return new SshPrivateKeyFile(formattedKey, sshPrivateKeyFormat);
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public static SshPrivateKeyFile parse(File keyfile) throws InvalidSshKeyException, IOException {
        SshPrivateKeyFile sshPrivateKeyFile = null;
        try (FileInputStream fileInputStream = new FileInputStream(keyfile);){
            sshPrivateKeyFile = SshPrivateKeyFile.parse(fileInputStream);
        }
        return sshPrivateKeyFile;
    }

    public static SshPrivateKeyFile parse(InputStream inStr) throws InvalidSshKeyException, IOException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n2 = 0;
        while ((n2 = inStr.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return SshPrivateKeyFile.parse(byteArrayOutputStream.toByteArray());
    }

    public boolean isPassphraseProtected() {
        return this.b.isPassphraseProtected(this.c);
    }

    public static SshPrivateKeyFile create(SshPrivateKey key, String passphrase, SshPrivateKeyFormat format) throws InvalidSshKeyException {
        byte[] byArray = format.encryptKeyblob(key.getEncoded(), passphrase);
        return new SshPrivateKeyFile(byArray, format);
    }

    public void setFormat(SshPrivateKeyFormat newFormat, String passphrase) throws InvalidSshKeyException {
        byte[] byArray = this.b.decryptKeyblob(this.c, passphrase);
        this.b = newFormat;
        this.c = this.b.encryptKeyblob(byArray, passphrase);
    }

    public SshPrivateKeyFormat getFormat() {
        return this.b;
    }

    public SshPrivateKey toPrivateKey(String passphrase) throws InvalidSshKeyException {
        String string = "";
        try {
            byte[] byArray = this.b.decryptKeyblob(this.c, passphrase);
            string = this.a(byArray);
            a.debug("toPrivateKey(" + string + ")");
            SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
            return sshKeyPair.decodePrivateKey(byArray);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InvalidSshKeyException("The public key algorithm " + string + " for this private key is not supported", algorithmNotSupportedException);
        }
    }

    public String toString() {
        return new String(this.c);
    }

    private String a(byte[] byArray) {
        return ByteArrayReader.readString(byArray, 0);
    }
}

