/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKeyFormatFactory;
import com.enterprisedt.util.debug.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SshPublicKeyFile {
    private static Logger a = Logger.getLogger("SshPublicKeyFile");
    private static int b = 131072;
    private SshPublicKeyFormat c;
    private byte[] d;
    private String e;

    protected SshPublicKeyFile(byte[] keyblob, SshPublicKeyFormat format) {
        this.d = keyblob;
        this.c = format;
    }

    public byte[] getBytes() {
        return this.c.formatKey(this.d);
    }

    public String getComment() {
        return this.e;
    }

    public void setComment(String comment) {
        this.e = comment;
    }

    public byte[] getKeyBlob() {
        return this.d;
    }

    public static SshPublicKeyFile create(SshPublicKey key, SshPublicKeyFormat format) {
        SshPublicKeyFile sshPublicKeyFile = new SshPublicKeyFile(key.getEncoded(), format);
        sshPublicKeyFile.setComment(format.getComment());
        return sshPublicKeyFile;
    }

    public static SshPublicKeyFile parse(File keyfile) throws InvalidSshKeyException, IOException {
        FileInputStream fileInputStream = new FileInputStream(keyfile);
        SshPublicKeyFile sshPublicKeyFile = SshPublicKeyFile.parse(fileInputStream);
        fileInputStream.close();
        return sshPublicKeyFile;
    }

    public static SshPublicKeyFile parse(InputStream in) throws InvalidSshKeyException, IOException {
        byte[] byArray = new byte[in.available()];
        in.read(byArray);
        return SshPublicKeyFile.parse(byArray);
    }

    public static SshPublicKeyFile parse(byte[] formattedKey) throws InvalidSshKeyException {
        Object object;
        a.debug("Parsing public key file");
        SshPublicKeyFormat sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(SshPublicKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPublicKeyFormat.isFormatted(formattedKey);
        if (!bl) {
            a.debug("Public key is not in the default format, attempting parse with other supported formats");
            object = SshPublicKeyFormatFactory.getSupportedFormats().iterator();
            while (object.hasNext() && !bl) {
                String string = (String)object.next();
                a.debug("Attempting " + string);
                sshPublicKeyFormat = SshPublicKeyFormatFactory.newInstance(string);
                bl = sshPublicKeyFormat.isFormatted(formattedKey);
            }
        }
        if (bl) {
            object = new SshPublicKeyFile(sshPublicKeyFormat.getKeyBlob(formattedKey), sshPublicKeyFormat);
            ((SshPublicKeyFile)object).setComment(sshPublicKeyFormat.getComment());
            return object;
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    public String getAlgorithm() {
        return ByteArrayReader.readString(this.d, 0);
    }

    public void setFormat(SshPublicKeyFormat newFormat) throws InvalidSshKeyException {
        if (!newFormat.supportsAlgorithm(this.getAlgorithm())) {
            throw new InvalidSshKeyException("The format does not support the public key algorithm");
        }
        newFormat.setComment(this.c.getComment());
        this.c = newFormat;
    }

    public SshPublicKeyFormat getFormat() {
        return this.c;
    }

    public SshPublicKey toPublicKey() throws IOException {
        ByteArrayReader byteArrayReader = new ByteArrayReader(this.d);
        String string = byteArrayReader.readString(b);
        SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(string);
        return sshKeyPair.decodePublicKey(this.d);
    }

    public String toString() {
        return new String(this.c.formatKey(this.d));
    }
}

