/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.cryptix.provider.key.DES_EDE3KeyGenerator;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.Base64EncodedFileFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.util.Hash;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import xjava.security.Cipher;
import xjava.security.FeedbackCipher;
import xjava.security.SecretKey;

public class SshtoolsPrivateKeyFormat
extends Base64EncodedFileFormat
implements SshPrivateKeyFormat {
    private final int a = 1391688382;

    public SshtoolsPrivateKeyFormat(String subject, String comment) {
        super("---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----", "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----");
        this.setHeaderValue("Subject", subject);
        this.setHeaderValue("Comment", comment);
    }

    public SshtoolsPrivateKeyFormat() {
        super("---- BEGIN SSHTOOLS ENCRYPTED PRIVATE KEY ----", "---- END SSHTOOLS ENCRYPTED PRIVATE KEY ----");
    }

    @Override
    public String getFormatType() {
        return "SSHTools-PrivateKey-" + super.getFormatType();
    }

    @Override
    public boolean isPassphraseProtected(byte[] formattedKey) {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(this.getKeyBlob(formattedKey));
            String string = byteArrayReader.readString();
            if (string.equals("none")) {
                return false;
            }
            if (string.equalsIgnoreCase("3des-cbc")) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public byte[] decryptKeyblob(byte[] formattedKey, String passphrase) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader;
            byte[] byArray = this.getKeyBlob(formattedKey);
            ByteArrayReader byteArrayReader2 = new ByteArrayReader(byArray);
            String string = byteArrayReader2.readString();
            if (!string.equalsIgnoreCase("3des-cbc")) return byteArrayReader2.readBinaryString();
            byte[] byArray2 = this.a(passphrase);
            byte[] byArray3 = new byte[8];
            if (string.equals("3DES-CBC")) {
                byteArrayReader2.read(byArray3);
            }
            byArray = byteArrayReader2.readBinaryString();
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "CryptixEDT");
            SecretKey secretKey = new DES_EDE3KeyGenerator().generateKey(byArray2);
            cipher.initDecrypt(secretKey);
            if (cipher instanceof FeedbackCipher) {
                ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray3);
            }
            if ((byteArrayReader = new ByteArrayReader(cipher.doFinal(byArray))).readInt() != 1391688382L) throw new InvalidSshKeyException("The host key is invalid, check the passphrase supplied");
            return byteArrayReader.readBinaryString();
        }
        catch (Exception exception) {
            throw new InvalidSshKeyException("Failed to read host key", exception);
        }
    }

    @Override
    public byte[] encryptKeyblob(byte[] keyblob, String passphrase) {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            String string = "none";
            if (passphrase != null && !passphrase.trim().equals("")) {
                string = "3DES-CBC";
                byte[] byArray = this.a(passphrase);
                byte[] byArray2 = new byte[8];
                ConfigurationLoader.getRND().nextBytes(byArray2);
                Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding", "CryptixEDT");
                SecretKey secretKey = new DES_EDE3KeyGenerator().generateKey(byArray);
                cipher.initEncrypt(secretKey);
                if (cipher instanceof FeedbackCipher) {
                    ((FeedbackCipher)((Object)cipher)).setInitializationVector(byArray2);
                }
                ByteArrayWriter byteArrayWriter2 = new ByteArrayWriter();
                byteArrayWriter.writeString(string);
                byteArrayWriter.write(byArray2);
                byteArrayWriter2.writeInt(1391688382);
                byteArrayWriter2.writeBinaryString(keyblob);
                byteArrayWriter.writeBinaryString(cipher.doFinal(byteArrayWriter2.toByteArray()));
                return this.formatKey(byteArrayWriter.toByteArray());
            }
            byteArrayWriter.writeString(string);
            byteArrayWriter.writeBinaryString(keyblob);
            return this.formatKey(byteArrayWriter.toByteArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public boolean supportsAlgorithm(String algorithm) {
        return true;
    }

    private byte[] a(String string) {
        try {
            Hash hash = new Hash("MD5");
            hash.putBytes(string.getBytes());
            byte[] byArray = hash.doFinal();
            hash.reset();
            hash.putBytes(string.getBytes());
            hash.putBytes(byArray);
            byte[] byArray2 = hash.doFinal();
            byte[] byArray3 = new byte[32];
            System.arraycopy(byArray, 0, byArray3, 0, 16);
            System.arraycopy(byArray2, 0, byArray3, 16, 16);
            return byArray3;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            return null;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
    }
}

