/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.ed25519;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.Ed25519Signer;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

public class SshEd25519PublicKey
extends SshPublicKey {
    private static Logger a = Logger.getLogger(SshEd25519PublicKey.class);
    private Ed25519PublicKeyParameters b;

    public SshEd25519PublicKey(Ed25519PublicKeyParameters pubkeyParams) {
        this.b = pubkeyParams;
    }

    public SshEd25519PublicKey(byte[] encoded) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(encoded);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!string.equals(this.getKeyFormatName())) {
                throw new InvalidSshKeyException(string);
            }
            this.b = new Ed25519PublicKeyParameters(byteArrayReader.readBinaryString());
        }
        catch (Exception exception) {
            a.error("SshEd25519PublicKey", exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    @Override
    public String getKeyFormatName() {
        return SshKeyPairFactory.ED_25519;
    }

    @Override
    public void setKeyAlgorithmName(String algorithmName) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("Key algorithm must be set to ED_25519");
    }

    @Override
    public String getKeyAlgorithmName() {
        return SshKeyPairFactory.ED_25519;
    }

    @Override
    public int getBitLength() {
        return 256;
    }

    protected Digest getDigest() {
        return new SHA512Digest();
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyFormatName());
            byteArrayWriter.writeBinaryString(this.b.getEncoded());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public boolean verifySignature(byte[] signature, byte[] data) throws InvalidSshKeySignatureException {
        try {
            a.debug("Signature length=" + signature.length);
            ByteArrayReader byteArrayReader = new ByteArrayReader(signature);
            String string = new String(byteArrayReader.readBinaryString());
            if (!string.equals(this.getKeyFormatName())) {
                a.error("Sig algorithm (" + string + ") does not match algorithm (" + this.getKeyFormatName() + ")");
                throw new InvalidSshKeySignatureException();
            }
            byte[] byArray = byteArrayReader.readBinaryString();
            Ed25519Signer ed25519Signer = new Ed25519Signer();
            ed25519Signer.init(false, this.b);
            ed25519Signer.update(data, 0, data.length);
            return ed25519Signer.verifySignature(byArray);
        }
        catch (IOException iOException) {
            String string = "Failed to verify signature";
            a.error(string, iOException);
            throw new InvalidSshKeySignatureException(string);
        }
    }
}

