/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.ed25519;

import com.enterprisedt.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.signers.Ed25519Signer;
import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.ed25519.SshEd25519PublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;

class a
extends SshPrivateKey {
    private static Logger a = Logger.getLogger("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPrivateKey");
    private Ed25519PrivateKeyParameters b;

    public a(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString(SshKeyPairFactory.MAX_ALGORITHM_NAME_LEN);
            if (!string.equals(this.getKeyFormatName())) {
                throw new InvalidSshKeyException(string);
            }
            this.b = new Ed25519PrivateKeyParameters(byteArrayReader.readBinaryString());
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            a.error(string, exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    @Override
    public String getKeyFormatName() {
        return SshKeyPairFactory.ED_25519;
    }

    @Override
    public void setKeyAlgorithmName(String algorithmName) throws InvalidSshKeyException {
        throw new InvalidSshKeyException("Key algorithm must be set to " + SshKeyPairFactory.ED_25519);
    }

    @Override
    public String getKeyAlgorithmName() {
        return SshKeyPairFactory.ED_25519;
    }

    @Override
    public int getBitLength() {
        return 256;
    }

    @Override
    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyFormatName());
            byteArrayWriter.writeBinaryString(this.b.getEncoded());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public SshPublicKey getPublicKey() {
        try {
            return new SshEd25519PublicKey(this.b.generatePublicKey());
        }
        catch (Exception exception) {
            a.error("getPublicKey()", exception);
            return null;
        }
    }

    @Override
    public byte[] generateSignature(byte[] data) throws InvalidSshKeySignatureException {
        try {
            Ed25519Signer ed25519Signer = new Ed25519Signer();
            ed25519Signer.init(true, this.b);
            ed25519Signer.update(data, 0, data.length);
            byte[] byArray = ed25519Signer.generateSignature();
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getKeyAlgorithmName());
            byteArrayWriter.writeBinaryString(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (Exception exception) {
            throw new InvalidSshKeySignatureException(exception);
        }
    }
}

