/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.BitSet;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DERUtils {
    public static final byte BOOLEAN = 1;
    public static final byte INTEGER = 2;
    public static final byte BIT_STRING = 3;
    public static final byte OCTET_STRING = 4;
    public static final byte OID = 6;
    public static final byte SET = 49;
    public static final byte SEQUENCE = 48;
    public static final byte IA5STRING = 22;
    public static final byte PRINTABLE_STRING = 19;
    public static final byte T61STRING = 20;
    public static final byte UTCTIME = 23;
    private static final int[] a = new int[]{32, 39, 40, 41, 43, 44, 45, 46, 47, 58, 61, 63};

    private static void a(int n2, OutputStream outputStream) throws IOException {
        if (n2 < 128) {
            outputStream.write((byte)n2);
        } else {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n3 = 1;
            while (n2 > 0) {
                byteArrayOutputStream.write((byte)(n2 & 0xFF));
                n2 >>= 8;
                ++n3;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            outputStream.write((byte)(0x80 | byArray.length));
            for (n3 = 0; n3 < byArray.length; ++n3) {
                outputStream.write(byArray[byArray.length - (n3 + 1)]);
            }
        }
    }

    private static void a(byte by, byte[] byArray, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        DERUtils.a(byArray.length, outputStream);
        outputStream.write(byArray);
    }

    public static void encodeInteger(BigInteger i2, OutputStream os) throws IOException {
        byte[] byArray = i2.toByteArray();
        if (byArray[0] == 0 && byArray.length > 1 && (byArray[1] & 0x80) == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            byArray = byArray2;
        }
        DERUtils.a((byte)2, byArray, os);
    }

    public static void encodeSequence(byte[] in, OutputStream os) throws IOException {
        DERUtils.a((byte)48, in, os);
    }

    public static void encodeSequence(ByteArrayOutputStream is, OutputStream os) throws IOException {
        byte[] byArray = is.toByteArray();
        DERUtils.encodeSequence(byArray, os);
    }

    public static void encodeSet(byte[] in, OutputStream os) throws IOException {
        DERUtils.a((byte)49, in, os);
    }

    public static void encodeSet(ByteArrayOutputStream is, OutputStream os) throws IOException {
        byte[] byArray = is.toByteArray();
        DERUtils.encodeSet(byArray, os);
    }

    public static void encodeOID(byte[] in, OutputStream os) throws IOException {
        DERUtils.a((byte)6, in, os);
    }

    private static void b(int n2, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[6];
        for (int i2 = 0; i2 < 6; ++i2) {
            byArray[i2] = (byte)(n2 & 0x7F);
            if ((n2 >>= 7) == 0) break;
        }
        for (int i3 = i2; i3 >= 0; --i3) {
            if (i3 == 0) {
                outputStream.write(byArray[i3]);
                continue;
            }
            outputStream.write(byArray[i3] | 0x80);
        }
    }

    public static void encodeOID(String oid, OutputStream os) throws IOException {
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringTokenizer stringTokenizer = new StringTokenizer(oid, ".");
        int[] nArray = new int[stringTokenizer.countTokens()];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = Integer.parseInt(stringTokenizer.nextToken());
        }
        byteArrayOutputStream.write(nArray[0] * 40 + nArray[1]);
        for (n2 = 2; n2 < nArray.length; ++n2) {
            DERUtils.b(nArray[n2], byteArrayOutputStream);
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        DERUtils.encodeOID(byArray, os);
    }

    public static void encodeIA5String(String in, OutputStream os) throws IOException {
        DERUtils.a((byte)22, in.getBytes(), os);
    }

    public static void encodePrintableString(String in, OutputStream os) throws IOException {
        DERUtils.a((byte)19, in.getBytes(), os);
    }

    private static boolean a(String string) {
        byte[] byArray = string.getBytes();
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            if (byArray[i2] >= 48 && byArray[i2] <= 57 || byArray[i2] >= 65 && byArray[i2] <= 90 || byArray[i2] >= 97 && byArray[i2] <= 122) continue;
            for (int i3 = 0; i3 < a.length; ++i3) {
                if (byArray[i2] != a[i3]) continue;
            }
            return false;
        }
        return true;
    }

    public static void encodeUnknownString(String in, OutputStream os) throws IOException {
        if (DERUtils.a(in)) {
            DERUtils.encodePrintableString(in, os);
        } else {
            DERUtils.encodeIA5String(in, os);
        }
    }

    public static void encodeBitString(byte[] in, OutputStream os) throws IOException {
        os.write(3);
        DERUtils.a(in.length + 1, os);
        os.write(0);
        os.write(in);
    }

    private static void a(byte[] byArray, int n2, int n3) {
        if (n2 > 99) {
            throw new InternalError("Illegal value");
        }
        if (n2 < 0) {
            throw new InternalError("Illegal value");
        }
        byArray[n3++] = (byte)(n2 / 10 + 48 & 0xFF);
        byArray[n3++] = (byte)(n2 % 10 + 48 & 0xFF);
    }

    public static void encodeUTCTime(long time, OutputStream os) throws IOException {
        byte[] byArray = new byte[13];
        int n2 = 0;
        Date date = new Date(time);
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(date);
        int n3 = gregorianCalendar.get(1);
        int n4 = gregorianCalendar.get(2);
        ++n4;
        int n5 = gregorianCalendar.get(5);
        int n6 = gregorianCalendar.get(11);
        int n7 = gregorianCalendar.get(12);
        int n8 = gregorianCalendar.get(13);
        if (n3 < 1950) {
            throw new InternalError("Bad time to encode " + gregorianCalendar.toString());
        }
        if (n3 > 2049) {
            throw new InternalError("Bad time to encode " + gregorianCalendar.toString());
        }
        n3 = n3 < 2000 ? (n3 -= 1900) : (n3 -= 2000);
        DERUtils.a(byArray, n3, n2);
        DERUtils.a(byArray, n4, n2 += 2);
        DERUtils.a(byArray, n5, n2 += 2);
        DERUtils.a(byArray, n6, n2 += 2);
        DERUtils.a(byArray, n7, n2 += 2);
        DERUtils.a(byArray, n8, n2 += 2);
        byArray[n2 += 2] = 90;
        DERUtils.a((byte)23, byArray, os);
    }

    public static byte[] decodeSequence(InputStream is) throws IOException {
        return DERUtils.a(48, is);
    }

    public static byte[] decodeOID(InputStream is) throws IOException {
        return DERUtils.a(6, is);
    }

    public static byte[] decodeOctetString(InputStream is) throws IOException {
        return DERUtils.a(4, is);
    }

    public static BigInteger decodeInteger(InputStream is) throws IOException {
        byte[] byArray = DERUtils.a(2, is);
        return new BigInteger(1, byArray);
    }

    public static int decodeIntegerX(InputStream is) throws IOException {
        BigInteger bigInteger = BigInteger.valueOf(0xFFFFFFFL);
        BigInteger bigInteger2 = DERUtils.decodeInteger(is);
        if (bigInteger2.compareTo(bigInteger) > 0) {
            throw new IOException("Overlarge big integer");
        }
        if (bigInteger2.compareTo(BigInteger.ZERO) < 0) {
            throw new IOException("Tried to decode negative number");
        }
        return bigInteger2.intValue();
    }

    public static BitSet decodeBitStringX(InputStream is) throws IOException {
        byte[] byArray = DERUtils.decodeBitString(is);
        byte by = byArray[0];
        BitSet bitSet = new BitSet();
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            int n2 = i2 != byArray.length - 1 ? 8 : 8 - by;
            int n3 = 128;
            for (int i3 = 0; i3 < n2; ++i3) {
                int n4 = byArray[i2] & 0xFF;
                if ((n3 & n4) == n3) {
                    bitSet.set((i2 - 1) * 8 + i3);
                }
                n3 >>= 1;
            }
        }
        return bitSet;
    }

    public static byte[] decodeBitString(InputStream is) throws IOException {
        return DERUtils.a(3, is);
    }

    public static boolean decodeBoolean(InputStream is) throws IOException {
        byte[] byArray = DERUtils.a(1, is);
        if (byArray.length != 1) {
            throw new IOException("Bad encoding for boolean");
        }
        switch (byArray[0]) {
            case -1: {
                return true;
            }
            case 0: {
                return false;
            }
        }
        throw new IOException("Boolean must be either 0xff or 0");
    }

    public static byte[] decodeAny(InputStream is) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = DERUtils.b(is);
        byte[] byArray = DERUtils.a(is);
        DERUtils.a((byte)n2, byArray, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private static byte[] a(int n2, InputStream inputStream) throws IOException {
        DERUtils.b(n2, inputStream);
        byte[] byArray = DERUtils.a(inputStream);
        return byArray;
    }

    private static byte[] a(InputStream inputStream) throws IOException {
        int n2;
        int n3 = DERUtils.c(inputStream);
        byte[] byArray = new byte[n3];
        if (n3 != 0 && (n2 = inputStream.read(byArray)) != n3) {
            throw new IOException("Bad encoding: short read (expected " + n3 + " but read " + n2 + ")");
        }
        return byArray;
    }

    private static void b(int n2, InputStream inputStream) throws IOException {
        int n3 = DERUtils.b(inputStream);
        if (n3 < 0 || n3 != n2) {
            throw new IOException("Bad encoding: wrong tag (expected " + n2 + " but read " + n3 + ")");
        }
    }

    private static int b(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        return n2;
    }

    private static boolean c(int n2, InputStream inputStream) throws IOException {
        int n3 = DERUtils.b(inputStream);
        if (n3 < 0) {
            return false;
        }
        return n3 == n2;
    }

    public static boolean isTag(int tag, InputStream is) throws IOException {
        is.mark(1);
        boolean bl = DERUtils.c(tag, is);
        is.reset();
        return bl;
    }

    private static int c(InputStream inputStream) throws IOException {
        int n2 = 0;
        int n3 = inputStream.read();
        if (n3 < 0) {
            throw new IOException("Bad encoding: short read");
        }
        if ((n3 & 0x80) == 0) {
            return n3;
        }
        int n4 = n3 & 0x7F;
        while (n4-- > 0) {
            n3 = inputStream.read();
            if (n3 < 0) {
                throw new IOException("Bad encoding: short read");
            }
            n2 *= 256;
            n2 += n3;
        }
        return n2;
    }
}

