/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.net.puretls.cert.DERUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;

public class EAYDHParams {
    private BigInteger a;
    private BigInteger b;

    public EAYDHParams(BigInteger g2, BigInteger p2) {
        this.b = p2;
        this.a = g2;
    }

    public EAYDHParams(byte[] encoding) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(encoding);
        byte[] byArray = DERUtils.decodeSequence(byteArrayInputStream);
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.b = DERUtils.decodeInteger(byteArrayInputStream);
        this.a = DERUtils.decodeInteger(byteArrayInputStream);
    }

    public BigInteger getG() {
        return this.a;
    }

    public BigInteger getP() {
        return this.b;
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream byteArrayOutputStream;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(this.b, byteArrayOutputStream);
            DERUtils.encodeInteger(this.a, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
        return byteArrayOutputStream.toByteArray();
    }
}

