/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.CertificateDecodeException;
import com.enterprisedt.net.puretls.cert.CertificateException;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.net.puretls.cert.X509Ext;
import com.enterprisedt.net.puretls.cert.X509Name;
import com.enterprisedt.net.puretls.cert.X509SubjectPublicKeyInfo;
import com.enterprisedt.net.puretls.cert.b;
import com.enterprisedt.net.puretls.cert.c;
import com.enterprisedt.net.puretls.sslg.CertVerifyPolicyInt;
import com.enterprisedt.net.puretls.sslg.Certificate;
import com.enterprisedt.net.puretls.sslg.DistinguishedName;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPublicKey;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class X509Cert
implements Certificate {
    private static Logger t = Logger.getLogger("X509Cert");
    ASNObject a;
    ASNObject b;
    ASNObject c;
    ASNObject d;
    ASNObject e;
    ASNObject f;
    byte[] g;
    byte[] h;
    byte[] i;
    byte[] j;
    byte[] k;
    String l;
    PublicKey m;
    X509Name n;
    X509Name o;
    BigInteger p;
    Date q;
    Date r;
    Vector s = null;
    private static Hashtable u = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509Cert(byte[] ber_) throws CertificateException {
        this.g = ber_;
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            ASNObject aSNObject = CertContext.getSpec().getComponent("UsefulCertificate");
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(ber_);
            coderOperations.init(byteArrayInputStream);
            try {
                aSNObject.accept(coderOperations, null);
                this.a = aSNObject;
                ASNObject aSNObject2 = aSNObject.getComponent("UsefulCertificate.tbsCertificate");
                this.h = (byte[])aSNObject2.getValue();
                this.e = aSNObject.getComponent("UsefulCertificate.signatureAlgorithm");
                Vector vector = (Vector)this.e.getValue();
                Vector vector2 = (Vector)vector.elementAt(0);
                this.l = (String)vector2.elementAt(0);
                SSLDebug.debug(32, "Signed by " + this.l);
                this.f = aSNObject.getComponent("UsefulCertificate.signature");
                byte[] byArray = (byte[])this.f.getValue();
                if (byArray[0] != 0) {
                    throw new IOException();
                }
                this.k = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, this.k, 0, this.k.length);
                SSLDebug.debug(32, "Signature ", this.k);
                this.b = CertContext.getSpec().getComponent("UsefulTBSCertificate");
                ASNObject aSNObject3 = this.b.getComponent("UsefulTBSCertificate.extensions");
                aSNObject3.setValue(aSNObject3.getDefaultValue());
                ASNObject aSNObject4 = this.b.getComponent("UsefulTBSCertificate.version");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                aSNObject4 = this.b.getComponent("UsefulTBSCertificate.issuerUniqueID");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                aSNObject4 = this.b.getComponent("UsefulTBSCertificate.subjectUniqueID");
                aSNObject4.setValue(aSNObject4.getDefaultValue());
                SSLDebug.debug(32, "Unsigned cert DER", this.h);
                byteArrayInputStream = new ByteArrayInputStream(this.h);
                coderOperations.init(byteArrayInputStream);
                this.b.accept(coderOperations, null);
                this.c = this.b.getComponent("UsefulTBSCertificate.issuer");
                this.j = (byte[])this.c.getValue();
                SSLDebug.debug(32, "Issuer DER", this.j);
                this.o = new X509Name(this.j);
                SSLDebug.debug(32, "Issuer Name = ", this.o.getNameString());
                this.d = this.b.getComponent("UsefulTBSCertificate.subject");
                this.i = (byte[])this.d.getValue();
                SSLDebug.debug(32, "Subject DER", this.i);
                this.n = new X509Name(this.i);
                SSLDebug.debug(32, "Subject Name = ", this.n.getNameString());
                ASNObject aSNObject5 = this.b.getComponent("UsefulTBSCertificate.subjectPublicKeyInfo");
                byte[] byArray2 = (byte[])aSNObject5.getValue();
                this.m = X509SubjectPublicKeyInfo.createPublicKey(byArray2);
                aSNObject2 = this.b.getComponent("UsefulTBSCertificate.serialNumber");
                this.p = (BigInteger)aSNObject2.getValue();
                SSLDebug.debug(32, "Serial Number = ", this.p.toString());
                ASNObject aSNObject6 = this.b.getComponent("UsefulTBSCertificate.validity");
                aSNObject2 = aSNObject6.getComponent("Validity.notBefore");
                this.q = (Date)aSNObject2.getValue();
                SSLDebug.debug(32, "Not valid before ", this.q);
                aSNObject2 = aSNObject6.getComponent("Validity.notAfter");
                SSLDebug.debug(32, "Not valid after ", this.r);
                this.r = (Date)aSNObject2.getValue();
                ASNObject aSNObject7 = this.b.getComponent("UsefulTBSCertificate.extensions");
                vector = (Vector)aSNObject7.getValue();
                if (vector != null) {
                    SSLDebug.debug(32, "Number of extensions = ", vector.size());
                    for (int i2 = 0; i2 < vector.size(); ++i2) {
                        if (i2 == 0) {
                            this.s = new Vector();
                        }
                        vector2 = (Vector)vector.elementAt(i2);
                        byte[] byArray3 = (byte[])vector2.elementAt(0);
                        SSLDebug.debug(32, "Extension " + i2, byArray3);
                        this.s.addElement(new X509Ext(byArray3));
                    }
                } else {
                    SSLDebug.debug(32, "No extensions");
                }
            }
            catch (IOException iOException) {
                throw new CertificateDecodeException(iOException.toString());
            }
        }
    }

    public String toString() {
        return "Issuer: " + this.o.getNameString() + ",Subject=" + this.n.getNameString();
    }

    public PublicKey getPublicKey() {
        return this.m;
    }

    @Override
    public byte[] getDER() {
        return this.g;
    }

    @Override
    public byte[] getIssuerDER() {
        return this.j;
    }

    @Override
    public byte[] getSubjectDER() {
        return this.i;
    }

    @Override
    public DistinguishedName getSubjectName() {
        return this.n;
    }

    @Override
    public DistinguishedName getIssuerName() {
        return this.o;
    }

    @Override
    public Date getValidityNotBefore() {
        return this.q;
    }

    @Override
    public Date getValidityNotAfter() {
        return this.r;
    }

    @Override
    public Vector getExtensions() {
        return this.s;
    }

    @Override
    public BigInteger getSerial() {
        return this.p;
    }

    void a(PublicKey publicKey, String string) throws CertificateVerifyException {
        if (string.equals("MD2/RSA") || string.equals("MD4/RSA") || string.equals("MD5/RSA") || string.equals("SHA-1/RSA/PKCS#1") || string.equals("SHA-256/RSA/PKCS#1") || string.equals("SHA-384/RSA/PKCS#1") || string.equals("SHA-512/RSA/PKCS#1")) {
            if (!(publicKey instanceof CryptixRSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string, this);
            }
        } else if (string.equals("DSA")) {
            if (!(publicKey instanceof DSAPublicKey)) {
                throw new CertificateVerifyException("Public key doesn't match algorithm " + string, this);
            }
        } else {
            throw new CertificateVerifyException("Unknown algorithm " + string, this);
        }
    }

    public boolean verify(PublicKey key) throws CertificateException {
        try {
            String string = (String)u.get(this.l);
            if (string == null) {
                String string2 = "unknown signature algorithm: " + this.l;
                t.error(string2);
                throw new CertificateVerifyException(string2, this);
            }
            SSLDebug.debug(32, "OID " + this.l + "mapped to " + string);
            this.a(key, string);
            String string3 = string != null ? string : this.l;
            Signature signature = Signature.getInstance(string3, "CryptixEDT");
            t.debug("verify: alg=" + string3 + ",provider=" + signature.getProvider().getName());
            signature.initVerify(key);
            signature.update(this.h);
            return signature.verify(this.k);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            t.error("verify", noSuchProviderException);
            throw new CertificateVerifyException(noSuchProviderException.toString(), this);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            t.error("verify", noSuchAlgorithmException);
            throw new CertificateVerifyException(noSuchAlgorithmException.toString(), this);
        }
        catch (SignatureException signatureException) {
            t.error("verify", signatureException);
            throw new CertificateVerifyException(signatureException.toString(), this);
        }
        catch (InvalidKeyException invalidKeyException) {
            t.error("verify", invalidKeyException);
            throw new CertificateVerifyException(invalidKeyException.toString(), this);
        }
    }

    public static Vector verifyCertChain(CertContext ctx, Vector certs, CertVerifyPolicyInt policy) throws IOException {
        int n2 = certs.size();
        Vector<X509Cert> vector = new Vector<X509Cert>();
        X509Cert x509Cert = null;
        boolean bl = false;
        int n3 = 255;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            X509Cert x509Cert2 = (X509Cert)certs.elementAt(i2);
            SSLDebug.debug(32, "Trying to verify", x509Cert2.getDER());
            if (!bl) {
                if (ctx.isRoot(x509Cert2.getDER())) {
                    SSLDebug.debug(32, "Is root");
                    x509Cert = x509Cert2;
                    vector.addElement(x509Cert);
                    bl = true;
                    continue;
                }
                SSLDebug.debug(32, "Trying to find root with DN", x509Cert2.getIssuerDER());
                x509Cert = ctx.signedByRoot(x509Cert2.getIssuerDER());
                if (x509Cert == null) {
                    SSLDebug.debug(32, "Nope");
                    continue;
                }
                SSLDebug.debug(32, "Found one");
                vector.addElement(x509Cert);
                bl = true;
            }
            if (!ArrayUtil.areEqual(x509Cert.getSubjectDER(), x509Cert2.getIssuerDER())) {
                String string = x509Cert2.getSubjectName().getNameString();
                throw new CertificateVerifyException("Invalid certificate chain at '" + string + "' certificate. Subject and issuer names do not match", certs);
            }
            if (!x509Cert2.verify(x509Cert.getPublicKey())) {
                String string = x509Cert2.getSubjectName().getNameString();
                throw new CertificateVerifyException("The signature of '" + string + "' certificate does not match its issuer", certs);
            }
            if (policy.checkDatesP()) {
                X509Cert.a(x509Cert2, new Date());
            }
            if (vector.size() == 1) {
                n4 = x509Cert.a(false, policy.requireBasicConstraintsCriticalP(), policy.allowBasicConstraintsInNonCAP());
                if (++n4 != -1) {
                    n3 = n4;
                }
                x509Cert.a(false);
            } else {
                n4 = x509Cert.a(policy.requireBasicConstraintsP(), policy.requireBasicConstraintsCriticalP(), policy.allowBasicConstraintsInNonCAP());
                if (++n4 < n3) {
                    n3 = n4;
                }
                x509Cert.a(policy.requireKeyUsageP());
            }
            if (n3 < 1) {
                throw new CertificateVerifyException("No more certificates allowed. Ran out of pathLen", certs);
            }
            --n3;
            x509Cert = x509Cert2;
            vector.addElement(x509Cert2);
        }
        if (x509Cert != null) {
            return vector;
        }
        return null;
    }

    static void a(Certificate certificate, Date date) throws CertificateVerifyException {
        Date date2 = certificate.getValidityNotBefore();
        if (date.before(date2)) {
            String string = certificate.getSubjectName().getNameString();
            throw new CertificateVerifyException("Certificate '" + string + "' not yet valid. Not before date " + date2, certificate);
        }
        Date date3 = certificate.getValidityNotAfter();
        if (date.after(date3)) {
            String string = certificate.getSubjectName().getNameString();
            throw new CertificateVerifyException("Certificate '" + string + "' expired. Not after date " + date3, certificate);
        }
    }

    private int a(boolean bl, boolean bl2, boolean bl3) throws CertificateVerifyException {
        b b2 = null;
        try {
            X509Ext x509Ext = X509Ext.a(this, com.enterprisedt.net.puretls.cert.b.a);
            if (x509Ext != null) {
                b2 = new b(x509Ext);
            }
        }
        catch (IOException iOException) {
            throw new CertificateVerifyException("Problem parsing Basic Constraints" + iOException.toString(), this);
        }
        if (b2 != null) {
            if (b2.b()) {
                if (bl2 && !b2.a()) {
                    throw new CertificateVerifyException("Basic constraints for a CA must be critical", this);
                }
                return b2.c();
            }
            if (!bl3) {
                throw new CertificateVerifyException("Basic Constraints present in signing cert but not a CA", this);
            }
            return b2.c();
        }
        if (bl) {
            throw new CertificateVerifyException("Basic Constraints not present", this);
        }
        return 255;
    }

    private void a(boolean bl) throws CertificateVerifyException {
        c c2 = null;
        try {
            X509Ext x509Ext = X509Ext.a(this, com.enterprisedt.net.puretls.cert.c.a);
            if (x509Ext != null) {
                c2 = new c(x509Ext);
            }
        }
        catch (IOException iOException) {
            throw new CertificateVerifyException("Problem parsing Key Usage" + iOException.toString(), this);
        }
        if (c2 == null) {
            if (bl) {
                throw new CertificateVerifyException("Key Usage required for CAs", this);
            }
        } else if (!c2.a(com.enterprisedt.net.puretls.cert.c.g)) {
            throw new CertificateVerifyException("Key Usage present but keyCertSign not asserted", this);
        }
    }

    static {
        u.put("1.2.840.10040.4.3", "DSA");
        u.put("1.2.840.113549.1.1.2", "MD2/RSA");
        u.put("1.2.840.113549.1.1.3", "MD4/RSA");
        u.put("1.2.840.113549.1.1.4", "MD5/RSA");
        u.put("1.2.840.113549.1.1.5", "SHA-1/RSA/PKCS#1");
        u.put("1.2.840.113549.1.1.11", "SHA-256/RSA/PKCS#1");
        u.put("1.2.840.113549.1.1.12", "SHA-384/RSA/PKCS#1");
        u.put("1.2.840.113549.1.1.13", "SHA-512/RSA/PKCS#1");
    }
}

