/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.crypto.RawDSAParams;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;

public class BaseDSAPrivateKey
implements DSAPrivateKey {
    protected BigInteger X = null;
    protected DSAParams params = null;

    protected BaseDSAPrivateKey() {
    }

    public BaseDSAPrivateKey(DSAPrivateKey key) {
        this.X = key.getX();
        DSAParams dSAParams = key.getParams();
        this.params = new RawDSAParams(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
    }

    @Override
    public BigInteger getX() {
        return this.X;
    }

    public BigInteger getY() {
        return this.params.getG().modPow(this.X, this.params.getP());
    }

    @Override
    public DSAParams getParams() {
        return this.params;
    }

    @Override
    public byte[] getEncoded() {
        return new byte[2];
    }

    @Override
    public String getFormat() {
        return "foo";
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }
}

