/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.crypto.a;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;

public class RandomStore {
    public static SecureRandom readRandomStore(String filename, byte[] password) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        if (!WrappedObject.findObject(bufferedReader, "RANDOM DATA", null)) {
            throw new IOException("Couldn't find randomness in this file");
        }
        byte[] byArray = a.a(bufferedReader, password);
        SSLDebug.debug(8, "Creating new PRNG seeded with", byArray);
        SecureRandom secureRandom = new SecureRandom(byArray);
        secureRandom.setSeed(System.currentTimeMillis());
        RandomStore.writeRandomStore(filename, password, secureRandom);
        return secureRandom;
    }

    public static void writeRandomStore(String filename, byte[] password, SecureRandom rnd) throws FileNotFoundException, IOException {
        FileWriter fileWriter = new FileWriter(filename);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        byte[] byArray = new byte[1024];
        rnd.nextBytes(byArray);
        a.a(byArray, password, "RANDOM DATA", bufferedWriter);
        rnd.setSeed(System.currentTimeMillis());
    }
}

