/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util;

public class Base32 {
    private static final byte[] a = new byte[]{26, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};

    public static String encode(byte[] bytes) {
        StringBuffer stringBuffer = new StringBuffer((bytes.length * 8 + 4) / 5);
        int n2 = 0;
        while (n2 < bytes.length) {
            int n3 = bytes[n2++] & 0xFF;
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n3 >> 3));
            int n4 = (n3 & 7) << 2;
            if (n2 >= bytes.length) {
                stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4));
                break;
            }
            n3 = bytes[n2++] & 0xFF;
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4 | n3 >> 6));
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n3 >> 1 & 0x1F));
            n4 = (n3 & 1) << 4;
            if (n2 >= bytes.length) {
                stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4));
                break;
            }
            n3 = bytes[n2++] & 0xFF;
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4 | n3 >> 4));
            n4 = (n3 & 0xF) << 1;
            if (n2 >= bytes.length) {
                stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4));
                break;
            }
            n3 = bytes[n2++] & 0xFF;
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4 | n3 >> 7));
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n3 >> 2 & 0x1F));
            n4 = (n3 & 3) << 3;
            if (n2 >= bytes.length) {
                stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4));
                break;
            }
            n3 = bytes[n2++] & 0xFF;
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n4 | n3 >> 5));
            stringBuffer.append("ABCDEFGHIJKLMNOPQRSTUVWXYZ234567".charAt(n3 & 0x1F));
        }
        return stringBuffer.toString();
    }

    public static byte[] decode(String base32) throws IllegalArgumentException {
        switch (base32.length() % 8) {
            case 1: 
            case 3: 
            case 6: {
                throw new IllegalArgumentException("non canonical Base32 string length");
            }
        }
        byte[] byArray = new byte[base32.length() * 5 / 8];
        int n2 = 0;
        int n3 = 0;
        while (n3 < base32.length()) {
            int n4;
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byte by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byte by2 = (byte)(by << 3);
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byArray[n2++] = (byte)(by2 | by >> 2);
            by2 = (byte)((by & 3) << 6);
            if (n3 >= base32.length()) {
                if (by2 == 0) break;
                throw new IllegalArgumentException("non canonical bits at end of Base32 string");
            }
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by2 = (byte)(by2 | (byte)(by << 1));
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byArray[n2++] = (byte)(by2 | by >> 4);
            by2 = (byte)((by & 0xF) << 4);
            if (n3 >= base32.length()) {
                if (by2 == 0) break;
                throw new IllegalArgumentException("non canonical bits at end of Base32 string");
            }
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byArray[n2++] = (byte)(by2 | by >> 1);
            by2 = (byte)((by & 1) << 7);
            if (n3 >= base32.length()) {
                if (by2 == 0) break;
                throw new IllegalArgumentException("non canonical bits at end of Base32 string");
            }
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by2 = (byte)(by2 | (byte)(by << 2));
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byArray[n2++] = (byte)(by2 | by >> 3);
            by2 = (byte)((by & 7) << 5);
            if (n3 >= base32.length()) {
                if (by2 == 0) break;
                throw new IllegalArgumentException("non canonical bits at end of Base32 string");
            }
            if ((n4 = base32.charAt(n3++) - 50) < 0 || n4 >= a.length) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            by = a[n4];
            if (by == -1) {
                throw new IllegalArgumentException("invalid character in Base32 string");
            }
            byArray[n2++] = (byte)(by2 | by);
        }
        return byArray;
    }
}

