/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.debug;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.util.debug.Appender;
import com.enterprisedt.util.debug.FileAppender;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.StandardOutputAppender;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;

public class Logger {
    public static String cvsId = "@(#)$Id: Logger.java,v 1.29 2011/06/09 07:37:09 bruceb Exp $";
    private static Level a;
    private static boolean b;
    private SimpleDateFormat c = new SimpleDateFormat("d MMM yyyy HH:mm:ss.SSS");
    private static Hashtable d;
    private static Vector e;
    private boolean f = false;
    private boolean g = false;
    private Date h = new Date();
    private String i;
    private Method[][] j = null;
    private Method k = null;
    private Method l = null;
    private Object m = null;
    private Object[] n = new Object[1];
    private Object[] o = new Object[2];
    private static String p;
    private static String[] q;

    private Logger(String clazz, boolean uselog4j) {
        this.i = clazz;
        this.f = uselog4j;
        if (uselog4j) {
            this.a();
        }
    }

    private synchronized void a() {
        this.j = new Method[5][2];
        try {
            Class<?> clazz = Class.forName("org.apache.log4j.Logger");
            Class<?> clazz2 = Class.forName("org.apache.log4j.Level");
            Class<?> clazz3 = Class.forName("org.apache.log4j.Priority");
            Class[] classArray = new Class[]{String.class};
            Method method = clazz.getMethod("getLogger", classArray);
            Object[] objectArray = new Object[]{this.i};
            this.m = method.invoke(null, objectArray);
            Class[] classArray2 = new Class[]{Object.class};
            Class[] classArray3 = new Class[]{Object.class, Throwable.class};
            this.j[0][0] = clazz.getMethod("fatal", classArray2);
            this.j[0][1] = clazz.getMethod("fatal", classArray3);
            this.j[1][0] = clazz.getMethod("error", classArray2);
            this.j[1][1] = clazz.getMethod("error", classArray3);
            this.j[2][0] = clazz.getMethod("warn", classArray2);
            this.j[2][1] = clazz.getMethod("warn", classArray3);
            this.j[3][0] = clazz.getMethod("info", classArray2);
            this.j[3][1] = clazz.getMethod("info", classArray3);
            this.j[4][0] = clazz.getMethod("debug", classArray2);
            this.j[4][1] = clazz.getMethod("debug", classArray3);
            Class[] classArray4 = new Class[]{String.class};
            this.k = clazz2.getMethod("toLevel", classArray4);
            Class[] classArray5 = new Class[]{clazz3};
            this.l = clazz.getMethod("isEnabledFor", classArray5);
        }
        catch (Exception exception) {
            this.f = false;
            this.error("Failed to initialize log4j logging", exception);
        }
    }

    public static synchronized Level getLevel() {
        return a;
    }

    public static synchronized void setLevel(Level level) {
        a = level;
    }

    public static Logger getLogger(Class clazz) {
        return Logger.getLogger(clazz.getName());
    }

    public static synchronized Logger getLogger(String clazz) {
        clazz = p + clazz;
        Logger logger = (Logger)d.get(clazz);
        if (logger == null) {
            boolean bl = false;
            try {
                String string = System.getProperty("edtftp.log.log4j");
                if (string != null && string.equalsIgnoreCase("true")) {
                    bl = true;
                }
            }
            catch (SecurityException securityException) {
                System.out.println("Could not read property 'edtftp.log.log4j' due to security permissions");
            }
            logger = new Logger(clazz, bl);
            d.put(clazz, logger);
        }
        return logger;
    }

    public static synchronized void addAppender(Appender newAppender) {
        if (!e.contains(newAppender)) {
            e.addElement(newAppender);
        }
    }

    public static synchronized void addFileAppender(String fileName) throws IOException {
        Logger.addAppender(new FileAppender(fileName));
    }

    public static synchronized void addStandardOutputAppender() {
        Logger.addAppender(new StandardOutputAppender());
    }

    public static synchronized void removeAppender(Appender appender) {
        appender.close();
        e.removeElement(appender);
    }

    public static synchronized void clearAppenders() {
        e.removeAllElements();
    }

    public static synchronized void shutdown() {
        for (int i2 = 0; i2 < e.size(); ++i2) {
            Appender appender = (Appender)e.elementAt(i2);
            appender.close();
        }
    }

    public static synchronized void logThreadNames(boolean logThreadNames) {
        b = logThreadNames;
    }

    public synchronized void logThreadName(boolean logThreadName) {
        this.g = logThreadName;
    }

    public synchronized void log(Level level, String message, Throwable t2) {
        if (this.isEnabledFor(level)) {
            if (this.f) {
                this.a(level, message, t2);
            } else {
                this.b(level, message, t2);
            }
        }
    }

    private boolean a(Level level) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        try {
            Object[] objectArray = new Object[]{level.toString()};
            Object object = this.k.invoke(null, objectArray);
            Object[] objectArray2 = new Object[]{object};
            Object object2 = this.l.invoke(this.m, objectArray2);
            return (Boolean)object2;
        }
        catch (Exception exception) {
            this.b(Level.ERROR, "Failed to invoke log4j toLevel/isEnabledFor method", exception);
            this.f = false;
            return false;
        }
    }

    private void a(Level level, String string, Throwable throwable) {
        if (level.equals(Level.ALL)) {
            level = Level.DEBUG;
        }
        Object[] objectArray = null;
        int n2 = -1;
        if (throwable == null) {
            objectArray = this.n;
            n2 = 0;
        } else {
            objectArray = this.o;
            objectArray[1] = throwable;
            n2 = 1;
        }
        objectArray[0] = string;
        Method method = this.j[level.getLevel()][n2];
        try {
            method.invoke(this.m, objectArray);
        }
        catch (Exception exception) {
            this.b(Level.ERROR, "Failed to invoke log4j logging method", exception);
            this.b(level, string, throwable);
            this.f = false;
        }
    }

    private void b(Level level, String string, Throwable throwable) {
        Object object;
        this.h.setTime(System.currentTimeMillis());
        String string2 = this.c.format(this.h);
        StringBuffer stringBuffer = new StringBuffer(level.toString());
        stringBuffer.append(" [");
        if (b || this.g) {
            stringBuffer.append(Thread.currentThread().getName()).append("_");
        }
        stringBuffer.append(this.i).append("] ").append(string2).append(" : ").append(string);
        if (throwable != null) {
            stringBuffer.append(" : ").append(throwable.getMessage());
            StringWriter stringWriter = new StringWriter();
            object = new PrintWriter(stringWriter);
            ((PrintWriter)object).println();
            throwable.printStackTrace((PrintWriter)object);
            ((PrintWriter)object).println();
            stringBuffer.append(stringWriter.toString());
        }
        if (e.size() == 0) {
            System.out.println(stringBuffer.toString());
            while (throwable != null) {
                throwable.printStackTrace(System.out);
                if (throwable instanceof BaseIOException) {
                    if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                    System.out.println("CAUSED BY:");
                    continue;
                }
                throwable = null;
            }
        } else {
            for (int i2 = 0; i2 < e.size(); ++i2) {
                object = (Appender)e.elementAt(i2);
                object.log(stringBuffer.toString());
                while (throwable != null) {
                    object.log(throwable);
                    if (throwable instanceof BaseIOException) {
                        if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                        object.log("CAUSED BY:");
                        continue;
                    }
                    throwable = null;
                }
            }
        }
    }

    public void info(String message) {
        this.log(Level.INFO, message, null);
    }

    public void info(String message, Throwable t2) {
        this.log(Level.INFO, message, t2);
    }

    public void warn(String message) {
        this.log(Level.WARN, message, null);
    }

    public void warn(String message, Throwable t2) {
        this.log(Level.WARN, message, t2);
    }

    public void error(String message) {
        this.log(Level.ERROR, message, null);
    }

    public void error(String message, Throwable t2) {
        this.log(Level.ERROR, message, t2);
    }

    public void fatal(String message) {
        this.log(Level.FATAL, message, null);
    }

    public void fatal(String message, Throwable t2) {
        this.log(Level.FATAL, message, t2);
    }

    public void debug(String message) {
        this.log(Level.DEBUG, message, null);
    }

    public void debug(String message, byte[] data) {
        this.log(Level.DEBUG, message, null);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i2 = 0; i2 < data.length; ++i2) {
            byte by = data[i2];
            if (i2 > 0 && i2 % 12 == 0) {
                this.log(Level.DEBUG, stringBuffer.toString() + "  " + stringBuffer2.toString(), null);
                stringBuffer = new StringBuffer();
                stringBuffer2 = new StringBuffer();
            }
            stringBuffer.append(q[by >> 4 & 0xF] + q[by & 0xF] + " ");
            stringBuffer2.append(by >= 32 && by <= 126 ? (char)by : (char)'?');
        }
        this.log(Level.DEBUG, stringBuffer.toString() + "  " + stringBuffer2.toString(), null);
    }

    public void debug(String message, Object arg) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2, arg3), null);
        }
    }

    public void debug(String message, Object arg0, Object arg1, Object arg2, Object arg3, Object arg4) {
        if (this.isDebugEnabled()) {
            this.log(Level.DEBUG, MessageFormat.format(message, arg0, arg1, arg2, arg3, arg4), null);
        }
    }

    public void debug(String message, Throwable t2) {
        this.log(Level.DEBUG, message, t2);
    }

    public synchronized boolean isEnabledFor(Level level) {
        if (this.f) {
            return this.a(level);
        }
        return a.a(level);
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(Level.DEBUG);
    }

    public boolean isInfoEnabled() {
        return this.isEnabledFor(Level.INFO);
    }

    static {
        b = false;
        d = new Hashtable(10);
        e = new Vector(2);
        String string = Level.OFF.toString();
        try {
            string = System.getProperty("edtftp.log.level", Level.OFF.toString());
        }
        catch (SecurityException securityException) {
            System.out.println("Could not read property 'edtftp.log.level' due to security permissions");
        }
        try {
            p = System.getProperty("edtftp.log.prefix");
            if (p == null) {
                p = "";
            }
        }
        catch (Throwable throwable) {
            System.out.println("Could not read property 'edtftp.log.prefix' due to security permissions");
            p = "";
        }
        a = Level.getLevel(string);
        if (a == null) {
            a = Level.OFF;
        }
        q = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    }
}

