/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.license;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.license.EDTProduct;
import com.enterprisedt.util.license.LicensePropertiesBase;
import com.enterprisedt.util.license.LicenseReader;
import java.io.FileNotFoundException;
import java.util.Properties;

public class LicenseProperties
extends LicensePropertiesBase {
    public static final String cvsId = "@(#)$Id: LicensePropertiesTrial.java,v 1.1 2018/08/02 09:34:35 bruceb Exp $";
    private static Logger b = Logger.getLogger("LicenseProperties");
    private LicenseReader c = new LicenseReader();

    public LicenseProperties() {
        try {
            this.a(LicenseProperties.a());
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unable to read license file. Is license.jar in the CLASSPATH?");
        }
    }

    public LicenseProperties(String licenseFile) throws FileNotFoundException {
        this.a(LicenseProperties.a(licenseFile));
    }

    public LicenseProperties(String owner, String key, String productStr) {
        this.owner = owner;
        this.key = key;
        this.productStr = productStr;
        this.product = EDTProduct.getProduct(productStr);
        this.flags = this.c.calcRegFlags(owner + productStr, key);
        this.isTrial = this.flags[0];
        this.expiryDate = this.c.calcRegExpiryDate(owner + productStr, key);
    }

    private void a(Properties properties) {
        if (properties == null) {
            throw new RuntimeException("Could not find license. Is license.jar in the CLASSPATH?");
        }
        this.key = LicenseProperties.a(properties, "license.key");
        this.owner = LicenseProperties.a(properties, "license.owner");
        this.productStr = LicenseProperties.a(properties, "license.product");
        this.product = EDTProduct.getProduct(this.productStr);
        this.flags = this.c.calcRegFlags(this.owner + this.productStr, this.key);
        this.isTrial = this.flags[0];
        this.expiryDate = this.c.calcRegExpiryDate(this.owner + this.productStr, this.key);
    }

    @Override
    public void checkLicence(EDTProduct[] expected) {
        super.checkLicence(expected);
        if (!this.isTrial) {
            String string = "This trial jar file cannot be used with a production license";
            b.error(string);
            throw new RuntimeException(string);
        }
    }

    public static void main(String[] args) {
        try {
            LicenseProperties licenseProperties = null;
            if (args.length == 0) {
                licenseProperties = new LicenseProperties();
            } else if (args.length >= 1) {
                licenseProperties = new LicenseProperties(args[0]);
            }
            System.out.println("Trial: " + licenseProperties.isTrial());
            System.out.println("Expiry: " + licenseProperties.a.format(licenseProperties.getExpiryDate()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

