/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.HttpHeader;
import com.enterprisedt.util.proxy.HttpRequest;
import com.enterprisedt.util.proxy.HttpResponse;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class HttpProxySocket
extends Socket
implements StreamSocket {
    private static Logger a = Logger.getLogger("HttpProxySocketProvider");
    private String b;
    private int c;
    private HttpResponse d;
    private String e;

    HttpProxySocket() {
    }

    @Override
    public boolean isSecureMode() {
        return false;
    }

    @Override
    public String getRemoteHost() {
        return this.b;
    }

    @Override
    public void setRemoteHost(String remoteHost) {
        this.b = remoteHost;
    }

    public static HttpProxySocket connectViaProxy(String host, int port, String proxyHost, int proxyPort, String username, String password, int timeout, String userAgent) throws IOException, UnknownHostException {
        return HttpProxySocket.connectViaProxy(host, port, proxyHost, proxyPort, null, username, password, timeout, userAgent);
    }

    public static HttpProxySocket connectViaProxy(String host, int port, String proxyHost, int proxyPort, String protocol, String username, String password, int timeout, String userAgent) throws IOException, UnknownHostException {
        int n2;
        String string;
        HttpProxySocket httpProxySocket = HttpProxySocket.a(proxyHost, proxyPort, timeout);
        httpProxySocket.setRemoteHost(host);
        try {
            InputStream inputStream = httpProxySocket.getInputStream();
            OutputStream outputStream = httpProxySocket.getOutputStream();
            HttpRequest httpRequest = new HttpRequest();
            if (protocol == null) {
                protocol = "";
            }
            httpRequest.setHeaderBegin("CONNECT " + protocol + host + ":" + port + " HTTP/1.1");
            httpRequest.setHeaderField("Host", host + ":" + port);
            httpRequest.setHeaderField("User-Agent", userAgent);
            httpRequest.setHeaderField("Pragma", "No-Cache");
            httpRequest.setHeaderField("Proxy-Connection", "Keep-Alive");
            outputStream.write(httpRequest.toString().getBytes("US-ASCII"));
            outputStream.flush();
            httpProxySocket.d = new HttpResponse(inputStream);
            string = httpProxySocket.d.getHeaderField("server");
            if (httpProxySocket.d.getStatus() == 407) {
                String string2 = httpProxySocket.d.getAuthenticationRealm();
                String string3 = httpProxySocket.d.getAuthenticationMethod();
                if (string2 == null) {
                    string2 = "";
                }
                if (string3.equalsIgnoreCase("basic")) {
                    httpProxySocket.close();
                    httpProxySocket = HttpProxySocket.a(proxyHost, proxyPort, timeout);
                    httpProxySocket.setRemoteHost(host);
                    inputStream = httpProxySocket.getInputStream();
                    outputStream = httpProxySocket.getOutputStream();
                    httpRequest.setBasicAuthentication(username, password);
                    outputStream.write(httpRequest.toString().getBytes("US-ASCII"));
                    outputStream.flush();
                    httpProxySocket.d = new HttpResponse(inputStream);
                } else {
                    if (string3.equalsIgnoreCase("digest")) {
                        throw new IOException("Digest authentication is not supported");
                    }
                    throw new IOException("'" + string3 + "' is not supported");
                }
            }
            n2 = httpProxySocket.d.getStatus();
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with proxy server " + proxyHost + ":" + proxyPort + " (" + socketException.getMessage() + ")");
        }
        if (n2 < 200 || n2 > 299) {
            throw new IOException("Proxy tunnel setup failed: " + httpProxySocket.d.getStartLine());
        }
        httpProxySocket.e = string;
        return httpProxySocket;
    }

    private static HttpProxySocket a(String string, int n2, int n3) throws IOException {
        HttpProxySocket httpProxySocket = new HttpProxySocket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        httpProxySocket.connect(inetSocketAddress, n3);
        return httpProxySocket;
    }

    @Override
    public String toString() {
        return "HTTPProxySocket [Proxy IP=" + this.getInetAddress() + ",Proxy Port=" + this.getPort() + ",localport=" + this.getLocalPort() + "Remote Host=" + this.b + "Remote Port=" + String.valueOf(this.c) + "]";
    }

    public HttpHeader getResponseHeader() {
        return this.d;
    }

    @Override
    public String getDetail() {
        return this.e;
    }
}

