/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.util.proxy;

import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.SocksProxySocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;

public class Socks4ProxySocket
extends SocksProxySocket {
    private static Logger a = Logger.getLogger("Socks4ProxySocket");
    public static final int SOCKS4 = 4;
    private static final String[] b = new String[]{"Request rejected or failed", "SOCKS server cannot connect to identd on the client", "The client program and identd report different user-ids"};

    @Override
    protected void sendRequest(int command, String remoteHost, int remotePort) throws IOException {
        try {
            InetAddress inetAddress = InetAddress.getByName(remoteHost);
            this.proxyOut.write(4);
            this.proxyOut.write((byte)command);
            this.proxyOut.write(remotePort >>> 8 & 0xFF);
            this.proxyOut.write(remotePort & 0xFF);
            this.proxyOut.write(inetAddress.getAddress());
            this.proxyOut.write(this.username.getBytes());
            this.proxyOut.write(0);
            this.proxyOut.flush();
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS4 server " + this.proxyHost + ":" + this.proxyPort + ", " + socketException.getMessage());
        }
    }

    @Override
    protected void readResponse() throws IOException {
        try {
            int n2 = this.proxyIn.read();
            if (n2 == -1) {
                throw new IOException("SOCKS4 server " + this.proxyHost + ":" + this.proxyPort + " disconnected");
            }
            if (n2 != 0) {
                throw new IOException("Invalid response from SOCKS4 server (" + n2 + ") " + this.proxyHost + ":" + this.proxyPort);
            }
            int n3 = this.proxyIn.read();
            if (n3 != 90) {
                if (n3 > 90 && n3 < 93) {
                    throw new IOException("SOCKS4 server unable to connect, reason: " + b[n3 - 91]);
                }
                throw new IOException("SOCKS4 server unable to connect, reason: " + n3);
            }
            byte[] byArray = new byte[6];
            if (this.proxyIn.read(byArray, 0, 6) != 6) {
                throw new IOException("SOCKS4 error reading destination address/port");
            }
            this.bindingAddress = (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF) + "." + (byArray[4] & 0xFF) + "." + (byArray[5] & 0xFF);
            this.bindingPort = (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
            this.providerDetail = this.bindingAddress + ":" + this.bindingPort;
        }
        catch (SocketException socketException) {
            throw new SocketException("Error communicating with SOCKS4 server " + this.proxyHost + ":" + this.proxyPort + ", " + socketException.getMessage());
        }
    }

    public static Socks4ProxySocket connectViaSocks4Proxy(String remoteHost, int remotePort, String proxyHost, int proxyPort, int timeout, String userId) throws IOException, UnknownHostException {
        Socks4ProxySocket socks4ProxySocket = Socks4ProxySocket.a(proxyHost, proxyPort, timeout);
        socks4ProxySocket.setRemoteHost(remoteHost);
        socks4ProxySocket.setUsername(userId);
        socks4ProxySocket.sendRequest(1, remoteHost, remotePort);
        socks4ProxySocket.readResponse();
        return socks4ProxySocket;
    }

    private static Socks4ProxySocket a(String string, int n2, int n3) throws IOException {
        Socks4ProxySocket socks4ProxySocket = new Socks4ProxySocket();
        socks4ProxySocket.setProxyHost(string);
        socks4ProxySocket.setProxyPort(n2);
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
        socks4ProxySocket.connect(inetSocketAddress, n3);
        return socks4ProxySocket;
    }
}

